<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch leave requests
$stmt = $pdo->query("
  SELECT l.*, u.username 
  FROM leave_requests l
  JOIN users u ON l.officer_id = u.id
  ORDER BY l.status = 'pending' DESC, l.created_at DESC
");
$requests = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View Leave Requests</title>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">

<div class="container mt-4">
  <h4>🗂 Officer Leave Requests</h4>

  <div class="table-responsive mt-3">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Type</th>
          <th>From</th>
          <th>To</th>
          <th>Reason</th>
          <th>Status</th>
          <th>Applied On</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($requests as $i => $r): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($r['username']) ?></td>
          <td><?= ucfirst($r['leave_type']) ?></td>
          <td><?= $r['start_date'] ?></td>
          <td><?= $r['end_date'] ?></td>
          <td><?= htmlspecialchars($r['reason']) ?></td>
          <td>
            <span class="badge bg-<?= $r['status'] === 'approved' ? 'success' : ($r['status'] === 'rejected' ? 'danger' : 'warning') ?>">
              <?= ucfirst($r['status']) ?>
            </span>
          </td>
          <td><?= date('d M Y H:i', strtotime($r['created_at'])) ?></td>
          <td>
            <?php if ($r['status'] === 'pending'): ?>
              <form method="post" action="approve_leave.php" class="d-inline">
                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                <input type="hidden" name="action" value="approve">
                <button class="btn btn-sm btn-success">✔️ Approve</button>
              </form>
              <form method="post" action="approve_leave.php" class="d-inline">
                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                <input type="hidden" name="action" value="reject">
                <button class="btn btn-sm btn-danger">❌ Reject</button>
              </form>
            <?php else: ?>
              <em class="text-muted">—</em>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($requests)): ?>
        <tr><td colspan="9" class="text-center text-muted">No leave requests found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>

</body>
</html>
