<?php
require_once '../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_user'])) {
  $id = intval($_POST['id']);

  // Optionally delete profile image
  $stmt = $pdo->prepare("SELECT profile_image FROM users WHERE id = ?");
  $stmt->execute([$id]);
  $user = $stmt->fetch();

  if ($user && !empty($user['profile_image'])) {
    $file = "../uploads/users/" . $user['profile_image'];
    if (file_exists($file)) {
      unlink($file); // delete image file
    }
  }

  // Delete user record
  $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
  $stmt->execute([$id]);

  header("Location: manage_users.php?deleted=1");
  exit;
}
?>
