<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$incident_id = $_GET['id'] ?? null;

if (!$incident_id) {
  echo "Invalid incident ID.";
  exit;
}

// Fetch the existing incident data
$stmt = $pdo->prepare("SELECT * FROM incident_reports WHERE id = ?");
$stmt->execute([$incident_id]);
$incident = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$incident) {
  echo "Incident not found.";
  exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $subject = $_POST['subject'] ?? '';
  $description = $_POST['description'] ?? '';
  $incident_date = $_POST['incident_date'] ?? '';
  $incident_time = $_POST['incident_time'] ?? '';
  $recording_officer = $_POST['recording_officer'] ?? '';

  // Update the incident
  $update = $pdo->prepare("UPDATE incident_reports SET subject = ?, description = ?, incident_date = ?, incident_time = ?, recording_officer = ? WHERE id = ?");
  $update->execute([$subject, $description, $incident_date, $incident_time, $recording_officer, $incident_id]);

  header("Location: incident_view.php?id=" . $incident_id);
  exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Edit Incident</title>
  <!-- AdminLTE & Bootstrap -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
    .content-wrapper { background-color: #f4f6f9; }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

    <?php include '../includes/topbar.php'; ?>
    <?php include '../includes/sidebar.php'; ?>

    <div class="content-wrapper">
          <section class="content-header">
            <div class="container-fluid d-flex justify-content-between align-items-center">
            <h4>Edit Incident Report</h4>
            </div>
          </section>

          <section class="content">
            <div class="container-fluid">
              
              <form method="POST">
                <div class="mb-3">
                  <label for="subject" class="form-label">Subject</label>
                  <input type="text" name="subject" id="subject" class="form-control" value="<?= htmlspecialchars($incident['subject']) ?>" required>
                </div>
                <div class="mb-3">
                  <label for="description" class="form-label">Description</label>
                  <textarea name="description" id="description" class="form-control" rows="4" required><?= htmlspecialchars($incident['description']) ?></textarea>
                </div>
                <div class="mb-3">
                  <label for="incident_date" class="form-label">Date</label>
                  <input type="date" name="incident_date" id="incident_date" class="form-control" value="<?= htmlspecialchars($incident['incident_date']) ?>" required>
                </div>
                <div class="mb-3">
                  <label for="incident_time" class="form-label">Time</label>
                  <input type="time" name="incident_time" id="incident_time" class="form-control" value="<?= htmlspecialchars($incident['incident_time']) ?>" required>
                </div>
                <div class="mb-3">
                  <label for="recording_officer" class="form-label">Recording Officer</label>
                  <input type="text" name="recording_officer" id="recording_officer" class="form-control" value="<?= htmlspecialchars($incident['recording_officer']) ?>" required>
                </div>
                <button type="submit" class="btn btn-primary">Update Incident</button>
                <a href="incident_reports.php" class="btn btn-secondary">Cancel</a>
              </form>
            </div>
          </section>

    </div>
</div>
<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

</body>
</html>
