<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$year = date('Y');

// Fetch data
$stmt = $pdo->prepare("
  SELECT l.*, u.username FROM leave_balance l
  JOIN users u ON l.officer_id = u.id
  WHERE l.year = ?
  ORDER BY u.username ASC
");
$stmt->execute([$year]);
$leaveList = $stmt->fetchAll();

$officers = $pdo->query("SELECT id, username FROM users WHERE role = 'officer' ORDER BY username ASC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Manage Leave | CFS System OS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- AdminLTE + Plugins -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>

  <!-- Main Content -->
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid d-flex justify-content-between align-items-center">
        <h4 class="m-0">📋 Officer Leave Entitlements - <?= $year ?></h4>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addLeaveModal">➕ Add Leave</button>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="card card-primary">
          <div class="card-body">
            <table id="leaveTable" class="table table-bordered table-striped table-sm">
              <thead class="table-dark">
                <tr>
                  <th>#</th>
                  <th>Officer</th>
                  <th>Annual</th>
                  <th>Medical</th>
                  <th>Hospital</th>
                  <th>Unpaid</th>
                  <th>Year</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($leaveList as $i => $row): ?>
                <tr>
                  <td><?= $i + 1 ?></td>
                  <td><?= htmlspecialchars($row['username']) ?></td>
                  <td><?= $row['annual_leave'] ?></td>
                  <td><?= $row['medical_leave'] ?></td>
                  <td><?= $row['hospital_leave'] ?></td>
                  <td><?= $row['unpaid_leave'] ?></td>
                  <td><?= $row['year'] ?></td>
                  <td>
                    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#edit<?= $row['id'] ?>">✏️</button>
                    <form method="post" action="manage_leave_action.php" class="d-inline" onsubmit="return confirm('Delete this record?')">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?= $row['id'] ?>">
                      <button class="btn btn-sm btn-danger">🗑</button>
                    </form>
                  </td>
                </tr>

                <!-- Edit Modal -->
                <div class="modal fade" id="edit<?= $row['id'] ?>" tabindex="-1">
                  <div class="modal-dialog">
                    <form method="post" action="manage_leave_action.php" class="modal-content">
                      <input type="hidden" name="action" value="update">
                      <input type="hidden" name="id" value="<?= $row['id'] ?>">
                      <div class="modal-header">
                        <h5 class="modal-title">Edit Leave: <?= htmlspecialchars($row['username']) ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <input name="annual_leave" class="form-control mb-2" type="number" value="<?= $row['annual_leave'] ?>" required>
                        <input name="medical_leave" class="form-control mb-2" type="number" value="<?= $row['medical_leave'] ?>" required>
                        <input name="hospital_leave" class="form-control mb-2" type="number" value="<?= $row['hospital_leave'] ?>" required>
                        <input name="unpaid_leave" class="form-control mb-2" type="number" value="<?= $row['unpaid_leave'] ?>" required>
                      </div>
                      <div class="modal-footer">
                        <button class="btn btn-success">Update</button>
                      </div>
                    </form>
                  </div>
                </div>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </section>
  </div>

  <!-- Add Modal -->
  <div class="modal fade" id="addLeaveModal" tabindex="-1">
    <div class="modal-dialog">
      <form method="post" action="manage_leave_action.php" class="modal-content">
        <input type="hidden" name="action" value="add">
        <div class="modal-header">
          <h5 class="modal-title">Add Leave Entitlement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <select name="officer_id" class="form-select mb-2" required>
            <option value="">-- Select Officer --</option>
            <?php foreach ($officers as $o): ?>
              <option value="<?= $o['id'] ?>"><?= htmlspecialchars($o['username']) ?></option>
            <?php endforeach; ?>
          </select>
          <input name="annual_leave" class="form-control mb-2" type="number" placeholder="Annual Leave" required>
          <input name="medical_leave" class="form-control mb-2" type="number" placeholder="Medical Leave" required>
          <input name="hospital_leave" class="form-control mb-2" type="number" placeholder="Hospital Leave" required>
          <input name="unpaid_leave" class="form-control mb-2" type="number" placeholder="Unpaid Leave" required>
          <input name="year" class="form-control mb-2" type="number" value="<?= $year ?>" placeholder="Year" required>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary">Add</button>
        </div>
      </form>
    </div>
  </div>

</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script>
  $(document).ready(() => {
    $('#leaveTable').DataTable();
  });
</script>
</body>
</html>
