<?php
session_start();
require_once '../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $severity = $_POST['severity'];
    $officer_id = $_SESSION['user_id'] ?? 1; // fallback for demo
    $site = $_POST['site'] ?? '';
    $filename = null;

    if (!empty($_FILES['evidence']['name'])) {
        $targetDir = "../uploads/incidents/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
        $filename = time() . "_" . basename($_FILES['evidence']['name']);
        move_uploaded_file($_FILES['evidence']['tmp_name'], $targetDir . $filename);
    }

    $stmt = $pdo->prepare("INSERT INTO incident_reports (officer_id, title, description, severity, site, evidence_file, reported_by) 
                           VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$officer_id, $title, $description, $severity, $site, $filename, 'officer']);

    $_SESSION['success'] = "Incident submitted successfully.";
    header("Location: incident_view.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head><title>Upload Incident</title></head>
<body>
<form method="post" enctype="multipart/form-data">
    <input name="title" placeholder="Incident Title" required><br>
    <textarea name="description" placeholder="Description" required></textarea><br>
    <select name="severity" required>
        <option value="critical">Critical</option>
        <option value="warning">Warning</option>
        <option value="info">Info</option>
    </select><br>
    <input name="site" placeholder="Site Name"><br>
    <input type="file" name="evidence"><br>
    <button type="submit">Submit Incident</button>
</form>
</body>
</html>
