<?php
session_start();
require_once '../includes/config.php';

// Authentication Check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

// Validate and retrieve officer ID from GET parameters
if (!isset($_GET['officer_id']) || !is_numeric($_GET['officer_id'])) {
    die("Invalid officer ID.");
}
$officer_id = (int)$_GET['officer_id'];

// Fetch officer details
$stmt = $pdo->prepare("SELECT u.id, u.username, u.full_name, s.site_name
                       FROM users u
                       LEFT JOIN sites s ON u.site_id = s.id
                       WHERE u.id = ?");
$stmt->execute([$officer_id]);
$officer = $stmt->fetch();

if (!$officer) {
    die("Officer not found.");
}

// Fetch payslip details
$payslip_stmt = $pdo->prepare("SELECT * FROM payslips WHERE officer_id = ? ORDER BY pay_date DESC LIMIT 1");
$payslip_stmt->execute([$officer_id]);
$payslip = $payslip_stmt->fetch();

if (!$payslip) {
    die("No payslip found for this officer.");
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Officer Payslip</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-size: 14px;
        }
        .payslip-container {
            max-width: 800px;
            margin: 30px auto;
            background: #fff;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        .section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            color: #004080;
        }
        .table th {
            background-color: #e9ecef;
        }
    </style>
</head>
<body>

<div class="payslip-container">
    <h4 class="mb-4">🧾 Officer Payslip</h4>
    <hr>

    <div class="mb-3">
        <strong>Officer Name:</strong> <?= htmlspecialchars($officer['full_name']) ?><br>
        <strong>Username:</strong> <?= htmlspecialchars($officer['username']) ?><br>
        <strong>Site:</strong> <?= htmlspecialchars($officer['site_name'] ?? 'Unassigned') ?><br>
        <strong>Pay Date:</strong> <?= date('F d, Y', strtotime($payslip['pay_date'])) ?>
    </div>

    <div class="section-title">Earnings</div>
    <table class="table table-bordered">
        <tr>
            <th>Description</th>
            <th class="text-end">Amount (SGD)</th>
        </tr>
        <tr>
            <td>Basic Salary</td>
            <td class="text-end"><?= number_format($payslip['basic_salary'], 2) ?></td>
        </tr>
        <tr>
            <td>Overtime</td>
            <td class="text-end"><?= number_format($payslip['overtime'], 2) ?></td>
        </tr>
        <tr>
            <td>Allowances</td>
            <td class="text-end"><?= number_format($payslip['allowances'], 2) ?></td>
        </tr>
        <tr>
            <th>Total Earnings</th>
            <th class="text-end"><?= number_format($payslip['basic_salary'] + $payslip['overtime'] + $payslip['allowances'], 2) ?></th>
        </tr>
    </table>

    <div class="section-title">Deductions</div>
    <table class="table table-bordered">
        <tr>
            <th>Description</th>
            <th class="text-end">Amount (SGD)</th>
        </tr>
        <tr>
            <td>CPF</td>
            <td class="text-end"><?= number_format($payslip['cpf'], 2) ?></td>
        </tr>
        <tr>
            <td>Tax</td>
            <td class="text-end"><?= number_format($payslip['tax'], 2) ?></td>
        </tr>
        <tr>
            <td>Other Deductions</td>
            <td class="text-end"><?= number_format($payslip['other_deductions'], 2) ?></td>
        </tr>
        <tr>
            <th>Total Deductions</th>
            <th class="text-end"><?= number_format($payslip['cpf'] + $payslip['tax'] + $payslip['other_deductions'], 2) ?></th>
        </tr>
    </table>

    <div class="section-title">Net Pay</div>
    <table class="table table-bordered">
        <tr>
            <th>Net Pay</th>
            <th class="text-end"><?= number_format($payslip['net_pay'], 2) ?> SGD</th>
        </tr>
    </table>

    <div class="mt-4">
        <a href="generate_payslip_pdf.php?officer_id=<?= $officer_id ?>" class="btn btn-primary">Download PDF</a>
        <a href="officers_list.php" class="btn btn-secondary">Back to Officers List</a>
    </div>
</div>

</body>
</html>
