<!DOCTYPE html>
<html>
<head>
  <title>Singapore Map with GPS Locations</title>
  <meta name="viewport" content="initial-scale=1.0, width=device-width" />
  <meta charset="utf-8" />
  <style>
    #map {
      height: 90vh;
      width: 100%;
    }
  </style>
</head>
<body>
  <h4 style="text-align:center;">🗺️ Singapore Map (with GPS Location Marker)</h4>
  <div id="map"></div>

  <script>
    let map;
    function initMap() {
      map = new google.maps.Map(document.getElementById("map"), {
        center: { lat: 1.3521, lng: 103.8198 }, // Singapore center
        zoom: 12,
      });

      // Example: Add a static GPS marker (can be loaded dynamically from DB or JS array)
      const sampleLocations = [
        { lat: 1.3000, lng: 103.8000, title: "Checkpoint A" },
        { lat: 1.3400, lng: 103.9600, title: "Checkpoint B" }
      ];

      sampleLocations.forEach(loc => {
        new google.maps.Marker({
          position: { lat: loc.lat, lng: loc.lng },
          map,
          title: loc.title
        });
      });
    }
  </script>

  <!-- Replace YOUR_API_KEY with a valid Google Maps JavaScript API key -->
  <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap" async defer></script>
</body>
</html>
