<?php
require_once '../includes/config.php';
$locations = [];

$stmt = $pdo->query("SELECT title, latitude, longitude FROM gps_locations");
if ($stmt) {
    $locations = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>GPS Map - Locations from Database</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <style>#map { height: 90vh; width: 100%; }</style>
</head>
<body>
  <h4 style="text-align:center;">📍 Singapore GPS Map - Live Locations</h4>
  <div id="map"></div>

  <script>
    let map;
    function initMap() {
      map = new google.maps.Map(document.getElementById("map"), {
        center: { lat: 1.3521, lng: 103.8198 },
        zoom: 12,
      });

      const locations = <?php echo json_encode($locations); ?>;
      locations.forEach(loc => {
        new google.maps.Marker({
          position: { lat: parseFloat(loc.latitude), lng: parseFloat(loc.longitude) },
          map,
          title: loc.title
        });
      });
    }
  </script>

  <!-- Replace YOUR_API_KEY with your real Google Maps JavaScript API Key -->
  <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap" async defer></script>
</body>
</html>
