<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (isset($_SESSION['user_id'])) {
    header("Location: ../dashboard.php");
    exit;
}

$message = $_SESSION['message'] ?? '';
unset($_SESSION['message']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login | CFS System OS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
     <style>
        body {
            background: #1e1e2f;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #fff;
        }
        .login-container {
            max-width: 400px;
            margin: auto;
            margin-top: 6%;
        }
        .login-card {
            background: #2c2f48;
            border-radius: 12px;
            box-shadow: 0 0 15px rgba(0,0,0,0.4);
            padding: 2rem;
            color: #fff;
        }
        .login-card .form-control {
            background: #3a3f5c;
            border: none;
            color: #fff;
        }
        .login-card .form-control:focus {
            background: #4a4f6c;
            color: #fff;
            box-shadow: none;
            border: 1px solid #6c63ff;
        }
        .btn-primary {
            background-color: #6c63ff;
            border: none;
        }
        .btn-primary:hover {
            background-color: #574dcf;
        }
        .logo {
            display: block;
            margin: 0 auto 20px auto;
            width: 120px;
        }
        a {
            color: #b3b8ff;
        }
        a:hover {
            color: #d5d8ff;
        }
    </style>
</head>
<body>

<div class="login-container">
    <img src="../assets/images/logo.png" alt="CFS Logo" class="logo">

    <div class="login-card">
        <h4 class="text-center mb-3">CFS System Login</h4>
        <?php if ($message): ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($message) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <form action="login_action.php" method="POST">
            <div class="mb-3">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" class="form-control" id="email" name="email" placeholder="you@example.com" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="remember" id="remember">
                <label class="form-check-label" for="remember">
                    Remember Me
                </label>
            </div>
            <button type="submit" class="btn btn-primary w-100">Sign In</button>
            <div class="mt-3 text-center">
                <a href="forgot_password.php">Forgot Password?</a>
            </div>
            <div class="mt-2 text-center">
                <a href="register.php">Don't have an account? Register</a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
