<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Fetch all incident reports
$query = "
  SELECT ir.*, u.username, s.site_name
  FROM incident_reports ir
  JOIN users u ON ir.officer_id = u.id
  JOIN sites s ON ir.site_id = s.id
  ORDER BY ir.id DESC
";
$incidents = $pdo->query($query)->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Incident Reports | CFS System OS</title>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content p-4">
  <h4>🚨 Incident Reports</h4>

  <div class="table-responsive mt-3">
    <table class="table table-bordered table-hover align-middle">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Site</th>
          <th>Title</th>
          <th>Description</th>
          <th>Media</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($incidents as $i => $row): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($row['username']) ?></td>
          <td><?= htmlspecialchars($row['site_name']) ?></td>
          <td><?= htmlspecialchars($row['title']) ?></td>
          <td><?= nl2br(htmlspecialchars($row['description'])) ?></td>
          <td>
            <?php if ($row['photo']): ?>
              <a href="../uploads/incidents/<?= $row['photo'] ?>" target="_blank" class="btn btn-sm btn-outline-primary mb-1">📷 Photo</a>
            <?php endif; ?>
            <?php if ($row['video']): ?>
              <a href="../uploads/incidents/<?= $row['video'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary">🎥 Video</a>
            <?php endif; ?>
          </td>
          <td>
            <span class="badge bg-<?= $row['status'] === 'resolved' ? 'success' : 'warning' ?>">
              <?= ucfirst($row['status']) ?>
            </span>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($incidents)): ?>
        <tr><td colspan="7" class="text-center text-muted">No incident reports found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

</body>
</html>
