<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$year = date('Y');

// Fetch leave balances
$stmt = $pdo->prepare("SELECT * FROM leave_balance WHERE officer_id = ? AND year = ?");
$stmt->execute([$officer_id, $year]);
$balance = $stmt->fetch();

// Fetch leave applications
$requests = $pdo->prepare("SELECT * FROM leave_requests WHERE officer_id = ? ORDER BY id DESC");
$requests->execute([$officer_id]);
$leaves = $requests->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>My Leave | CFS System OS</title>
  <meta charset="UTF-8" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>

<div class="container mt-4">
  <h4>🧾 My Leave Balance - <?= $year ?></h4>

  <?php if ($balance): ?>
  <div class="row mb-4">
    <div class="col"><strong>Annual:</strong> <?= $balance['annual_leave'] - $balance['used_annual'] ?>/<?= $balance['annual_leave'] ?></div>
    <div class="col"><strong>Medical:</strong> <?= $balance['medical_leave'] - $balance['used_medical'] ?>/<?= $balance['medical_leave'] ?></div>
    <div class="col"><strong>Hospital:</strong> <?= $balance['hospital_leave'] - $balance['used_hospital'] ?>/<?= $balance['hospital_leave'] ?></div>
    <div class="col"><strong>Unpaid:</strong> <?= $balance['unpaid_leave'] - $balance['used_unpaid'] ?>/<?= $balance['unpaid_leave'] ?></div>
  </div>
  <?php else: ?>
    <div class="alert alert-warning">Leave balance not set by admin yet.</div>
  <?php endif; ?>

  <h5 class="mb-3">📥 Apply for Leave</h5>
  <form method="post" action="leave_submit.php">
    <div class="row g-3 mb-3">
      <div class="col-md-3">
        <select name="leave_type" class="form-select" required>
          <option value="">Select type</option>
          <option value="annual">Annual</option>
          <option value="medical">Medical</option>
          <option value="hospital">Hospital</option>
          <option value="unpaid">Unpaid</option>
        </select>
      </div>
      <div class="col-md-3">
        <input type="date" name="start_date" class="form-control" required>
      </div>
      <div class="col-md-3">
        <input type="date" name="end_date" class="form-control" required>
      </div>
      <div class="col-md-3">
        <input type="text" name="reason" class="form-control" placeholder="Reason" required>
      </div>
    </div>
    <button class="btn btn-primary">Submit</button>
  </form>

  <hr class="my-4">

  <h5>📄 My Leave History</h5>
  <table class="table table-bordered table-striped">
    <thead class="table-dark">
      <tr>
        <th>Type</th>
        <th>Dates</th>
        <th>Reason</th>
        <th>Status</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($leaves as $l): ?>
      <tr>
        <td><?= ucfirst($l['leave_type']) ?></td>
        <td><?= $l['start_date'] ?> → <?= $l['end_date'] ?></td>
        <td><?= htmlspecialchars($l['reason']) ?></td>
        <td>
          <span class="badge bg-<?= $l['status'] === 'approved' ? 'success' : ($l['status'] === 'rejected' ? 'danger' : 'warning') ?>">
            <?= ucfirst($l['status']) ?>
          </span>
        </td>
      </tr>
      <?php endforeach; ?>
      <?php if (empty($leaves)): ?>
        <tr><td colspan="4" class="text-center text-muted">No leave requests yet.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
</body>
</html>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>