<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
    header("Location: ../auth/login.php");
    exit;
}

$attendance = null;
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['search'])) {
        // Search for attendance record
        $officer_id = $_POST['officer_id'];
        $date = $_POST['date'];

        $stmt = $pdo->prepare("SELECT a.*, u.username FROM attendance a JOIN users u ON a.officer_id = u.id WHERE a.officer_id = ? AND a.date = ?");
        $stmt->execute([$officer_id, $date]);
        $attendance = $stmt->fetch();

        if (!$attendance) {
            $error = 'No attendance record found for the selected officer and date.';
        }
    } elseif (isset($_POST['update'])) {
        // Update attendance record
        $attendance_id = $_POST['attendance_id'];
        $time_in = $_POST['time_in'];
        $time_out = $_POST['time_out'];

        $stmt = $pdo->prepare("UPDATE attendance SET time_in = ?, time_out = ? WHERE id = ?");
        if ($stmt->execute([$time_in, $time_out, $attendance_id])) {
            $success = 'Attendance record updated successfully.';
        } else {
            $error = 'Failed to update attendance record.';
        }
    }
}

// Fetch list of officers for the dropdown
$stmt = $pdo->query("SELECT id, username FROM users WHERE role = 'officer' ORDER BY username");
$officers = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="description" content="Controller Dashboard - CFS System OS">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Edit Officer Attendance</title>
    <link rel="stylesheet" href="../assets/css/controller_dashboard.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">
    <div class="container mt-4">

        <h4>📅 Edit Officer Attendance</h4>
        <hr>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>

        <form method="post" class="mb-4">
            <div class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label for="officer_id" class="form-label">Officer</label>
                    <select name="officer_id" id="officer_id" class="form-select" required>
                        <option value="">Select Officer</option>
                        <?php foreach ($officers as $officer): ?>
                            <option value="<?= $officer['id'] ?>" <?= (isset($_POST['officer_id']) && $_POST['officer_id'] == $officer['id']) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($officer['username']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="date" class="form-label">Date</label>
                    <input type="date" name="date" id="date" class="form-control" value="<?= htmlspecialchars($_POST['date'] ?? '') ?>" required>
                </div>
                <div class="col-md-2">
                    <button type="submit" name="search" class="btn btn-primary">Search</button>
                </div>
            </div>
        </form>

        <?php if ($attendance): ?>
            <form method="post">
                <input type="hidden" name="attendance_id" value="<?= $attendance['id'] ?>">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="time_in" class="form-label">Time In</label>
                        <input type="time" name="time_in" id="time_in" class="form-control" value="<?= substr($attendance['time_in'] ?? '', 0, 5) ?>" required>
                    </div>
                    <div class="col-md-3">
                        <label for="time_out" class="form-label">Time Out</label>
                        <input type="time" name="time_out" id="time_out" class="form-control" value="<?= substr($attendance['time_out'] ?? '', 0, 5) ?>" required>
                    </div>
                    <div class="col-md-2 align-self-end">
                        <button type="submit" name="update" class="btn btn-success">Update</button>
                    </div>
                </div>
            </form>
        <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
