<?php
session_start();
require_once '../includes/config.php';


$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

// Fetch assigned roster
$stmt = $pdo->prepare("
  SELECT r.*, s.site_name 
  FROM roster r 
  JOIN sites s ON r.site_id = s.id 
  WHERE r.officer_id = ? 
  ORDER BY r.shift_date DESC
");
$stmt->execute([$officer_id]);
$rosters = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>My Roster</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar_controller.php'; ?>

  <div class="content-wrapper">
    <section class="content-header">

      <div class="container mt-4">
        <h4 class="mb-4">📋 Roster for <?= htmlspecialchars($username) ?></h4>

            <div class="table-responsive">
              <table class="table table-bordered table-striped small">
                <thead class="table-dark">
                  <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Site</th>
                    <th>Shift</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($rosters as $i => $r): ?>
                  <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= date('d M Y', strtotime($r['shift_date'])) ?></td>
                    <td><?= htmlspecialchars($r['site_name']) ?></td>
                    <td><?= ucfirst($r['shift_type']) ?> Shift</td>
                  </tr>
                  <?php endforeach; ?>
                  <?php if (empty($rosters)): ?>
                  <tr><td colspan="4" class="text-center text-muted">No roster assigned yet.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
      </div>
    </section>
  </div>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
