<?php
session_start();
require_once '../includes/config.php';

// Dummy session for testing
// $_SESSION['officer_id'] = 1;

$officer_id = $_SESSION['officer_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_id = $_POST['site_id'];
    $category = $_POST['category'];
    $description = $_POST['description'];

    $stmt = $pdo->prepare("INSERT INTO occurrence_log (officer_id, site_id, category, description) VALUES (?, ?, ?, ?)");
    $stmt->execute([$officer_id, $site_id, $category, $description]);

    $success = "Occurrence logged successfully.";
}

$sites = $pdo->query("SELECT id, site_name FROM sites")->fetchAll();
$entries = $pdo->prepare("
  SELECT ol.*, s.site_name 
  FROM occurrence_log ol
  JOIN sites s ON ol.site_id = s.id
  WHERE ol.officer_id = ?
  ORDER BY ol.logged_at DESC
");
$entries->execute([$officer_id]);
$logs = $entries->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Occurrence Log</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>

<?php include '../includes/navbar.php'; ?>
<div class="container mt-4">
  <h4>📝 Occurrence Book Log</h4>

  <?php if (!empty($success)): ?>
    <div class="alert alert-success"><?= $success ?></div>
  <?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-md-4">
      <label>Site</label>
      <select name="site_id" class="form-control" required>
        <option value="">Select Site</option>
        <?php foreach ($sites as $site): ?>
          <option value="<?= $site['id'] ?>"><?= htmlspecialchars($site['site_name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label>Category</label>
      <select name="category" class="form-control" required>
        <option value="">Select Category</option>
        <option value="Patrol">Patrol</option>
        <option value="Visitor">Visitor</option>
        <option value="Alarm Trigger">Alarm Trigger</option>
        <option value="Suspicious Activity">Suspicious Activity</option>
        <option value="Other">Other</option>
      </select>
    </div>
    <div class="col-md-12">
      <label>Description</label>
      <textarea name="description" class="form-control" rows="3" required></textarea>
    </div>
    <div class="col-md-12 text-end">
      <button class="btn btn-primary">Log Occurrence</button>
    </div>
  </form>

  <hr class="my-4">

  <h5>📋 My Logged Occurrences</h5>
  <table class="table table-bordered">
    <thead class="table-dark">
      <tr>
        <th>Date & Time</th>
        <th>Site</th>
        <th>Category</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($logs as $log): ?>
        <tr>
          <td><?= $log['logged_at'] ?></td>
          <td><?= htmlspecialchars($log['site_name']) ?></td>
          <td><?= $log['category'] ?></td>
          <td><?= htmlspecialchars($log['description']) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
</body>
</html>
