<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';
$site_id = $_POST['site_id'] ?? $_SESSION['site_id'] ?? null;


// Auto-generate report number: REPYYYYMMDD0001
$datePrefix = date("Ymd");
$stmt = $pdo->prepare("SELECT COUNT(*) AS count FROM incident_reports WHERE report_number LIKE ?");
$stmt->execute(["REP{$datePrefix}%"]);
$countToday = (int)$stmt->fetchColumn() + 1;
$reportNumber = "REP{$datePrefix}" . str_pad($countToday, 4, '0', STR_PAD_LEFT); 

$sites = $pdo->query("SELECT id, site_name FROM sites ORDER BY site_name")->fetchAll();

// After inserting the incident report
$incident_id = $pdo->lastInsertId();

// Define the notification message
$message = "New incident reported at Site ID: $site_id by Officer ID: $officer_id.";

// Fetch all controller user IDs
$stmt = $pdo->query("SELECT id FROM users WHERE role = 'controller'");
$controllers = $stmt->fetchAll(PDO::FETCH_ASSOC);


?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Submit Incident Report</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/officer_dashboard.css">
  <style>
    body { background-color: #f5f9fc; font-family: 'Segoe UI', sans-serif; }
    .container { max-width: 700px; }
  </style>
</head>
<body>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="text-danger mb-4">🚨 Submit Incident Report</h4>
    <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
  </div>

  <form method="POST" action="submit_officer_incident.php" enctype="multipart/form-data">
    
    <div class="mb-3">
      <label class="form-label">Subject</label>
      <input type="text" name="subject" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Site</label>
      <select name="site_id" class="form-select" required>
        <option value="">-- Select Site --</option>
        <?php foreach ($sites as $site): ?>
          <option value="<?= $site['id'] ?>"><?= htmlspecialchars($site['site_name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="row">
      <div class="col-md-6 mb-3">
        <label class="form-label">Date of Incident</label>
        <input type="date" name="incident_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
      </div>
      <div class="col-md-6 mb-3">
        <label class="form-label">Time of Incident</label>
        <input type="time" name="incident_time" class="form-control" value="<?= date('H:i') ?>" required>
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label">Informant Name</label>
      <input type="text" name="informant_name" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Contact Number</label>
      <input type="text" name="contact_no" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Recording Officer</label>
      <input type="text" name="recording_officer" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Description of Incident</label>
      <textarea name="description" class="form-control" rows="4" required></textarea>
    </div>
    
    <div class="mb-3">
      <label class="form-label">Upload Photo(s)</label>
      <input type="file" name="photos[]" class="form-control" multiple accept="image/*">
    </div>

    <div class="mb-3">
      <label class="form-label">Upload Video(s)</label>
      <input type="file" name="videos[]" class="form-control" multiple accept="video/*">
    </div>

    <button type="submit" class="btn btn-danger w-100">Submit Incident</button>
  </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
