<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
    header("Location: ../auth/login.php");
    exit;
}

$officer_id = $_SESSION['user_id'];
$id = $_GET['id'] ?? 0;

$stmt = $pdo->prepare("SELECT * FROM incident_reports WHERE id = :id AND officer_id = :officer_id");
$stmt->execute([':id' => $id, ':officer_id' => $officer_id]);
$incident = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$incident) {
    $_SESSION['toast'] = ['type' => 'danger', 'message' => 'Incident not found or access denied.'];
    header("Location: view_incidents.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Incident Details</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container py-4">
  <h4 class="mb-4">📄 Incident Report #<?= htmlspecialchars($incident['report_number']) ?></h4>

  <div class="mb-3"><strong>Subject:</strong> <?= htmlspecialchars($incident['subject']) ?></div>
  <div class="mb-3"><strong>Informant:</strong> <?= htmlspecialchars($incident['informant_name']) ?></div>
  <div class="mb-3"><strong>Contact:</strong> <?= htmlspecialchars($incident['contact_no']) ?></div>
  <div class="mb-3"><strong>Recording Officer:</strong> <?= htmlspecialchars($incident['recording_officer']) ?></div>
  <div class="mb-3"><strong>Date:</strong> <?= $incident['incident_date'] ?> <strong>Time:</strong> <?= $incident['incident_time'] ?></div>
  <div class="mb-3"><strong>Description:</strong><br><?= nl2br(htmlspecialchars($incident['description'])) ?></div>
  <div class="mb-3"><strong>Status:</strong> <?= ucfirst($incident['status']) ?></div>
  <div class="mb-3"><strong>Reported At:</strong> <?= $incident['reported_at'] ?></div>

  <?php if (!empty($incident['photo'])): ?>
    <div class="mb-3">
      <strong>Photos:</strong>
      <div class="row">
        <?php foreach (json_decode($incident['photo']) as $photo): ?>
          <div class="col-md-4 mb-2">
            <img src="../uploads/incidents/photos/<?= $photo ?>" class="img-fluid rounded border">
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($incident['video'])): ?>
    <div class="mb-3">
      <strong>Videos:</strong>
      <?php foreach (json_decode($incident['video']) as $video): ?>
        <video controls class="w-100 mb-2">
          <source src="../uploads/incidents/videos/<?= $video ?>" type="video/mp4">
        </video>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <a href="view_incidents.php" class="btn btn-secondary mt-3">← Back</a>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
