<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
    header("Location: ../auth/login.php");
    exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

$stmt = $pdo->prepare("
  SELECT id, report_number, subject, incident_date, incident_time, status, reported_at
  FROM incident_reports
  WHERE officer_id = :officer_id
  ORDER BY reported_at DESC
");
$stmt->execute([':officer_id' => $officer_id]);
$reports = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>My Submitted Incidents</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  
  <style>
    table td, table th {
        white-space: normal;
        word-wrap: break-word;
    }
</style>
  
</head>
<body>
<div class="container py-4">
  <h4 class="mb-4">📄 My Submitted Incidents</h4>

  <?php if (isset($_SESSION['toast'])): ?>
    <div class="alert alert-<?= $_SESSION['toast']['type'] ?> alert-dismissible fade show" role="alert">
      <?= $_SESSION['toast']['message'] ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['toast']); ?>
  <?php endif; ?>
    <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <thead class="table-dark">
          <tr>
            <th>Report #</th>
            <th>Subject</th>
            <th>Date</th>
            <th>Time</th>
            <th>Status</th>
            <th>View</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($reports as $report): ?>
            <tr>
              <td><?= htmlspecialchars($report['report_number']) ?></td>
              <td><?= htmlspecialchars($report['subject']) ?></td>
              <td><?= $report['incident_date'] ?></td>
              <td><?= $report['incident_time'] ?></td>
              <td><?= ucfirst($report['status']) ?></td>
              <td>
                <a href="view_incident_detail.php?id=<?= $report['id'] ?>" class="btn btn-sm btn-info">Details</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  <a href="dashboard.php" class="btn btn-secondary mt-3">← Back to Dashboard</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
