<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

$stmt = $pdo->prepare("SELECT * FROM payslips WHERE officer_id = ? ORDER BY id DESC");
$stmt->execute([$officer_id]);
$payslips = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>My Payslips</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
  <style>
    body {
      background-color: #f8fafd;
      font-family: 'Segoe UI', sans-serif;
    }
    .container {
      max-width: 900px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="text-primary">💼 My Payslips</h4>
    <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
  </div>

  <?php if (empty($payslips)): ?>
    <div class="alert alert-info">No payslips uploaded yet.</div>
  <?php else: ?>
    <div class="table-responsive">
      <table id="payslipTable" class="table table-bordered table-hover">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Month</th>
            <th>Download</th>
            <th>Uploaded</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($payslips as $i => $p): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($p['month']) ?></td>
              <td>
                <a href="../uploads/payslips/<?= $p['file_path'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                  📄 View PDF
                </a>
              </td>
              <td><?= date('d M Y', strtotime($p['uploaded_at'] ?? $p['month'])) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $(document).ready(function () {
    $('#payslipTable').DataTable({
      dom: 'Bfrtip',
      buttons: ['excelHtml5', 'print'],
      order: [[1, 'desc']]
    });
  });
</script>

</body>
</html>
